/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.history.renderer;

import com.google.common.annotations.VisibleForTesting;

import net.bluemind.core.container.model.ItemChangeLogEntry;
import net.bluemind.core.container.model.ItemChangelog;
import net.bluemind.core.container.service.IChangelogOriginRenderer;
import net.bluemind.core.context.SecurityContext;

public class WebServerOriginRenderer implements IChangelogOriginRenderer {

	@Override
	public ItemChangelog render(SecurityContext sc, ItemChangelog raw) {

		for (ItemChangeLogEntry cle : raw.entries) {
			if (cle.origin != null) {
				cle.origin = processOrigin(cle.origin);
			}
		}

		return raw;
	}

	@VisibleForTesting
	public String processOrigin(String origin) {
		return origin.startsWith("bm-webserver-authfilter") ? "BlueMind Web" : origin;
	}

}
