<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * CalendarDescriptor.
 */
class CalendarDescriptor  {

  /*
   * @type String
   */
  public $name;

  /*
   * @type String
   */
  public $domainUid;

  /*
   * @type Map
   */
  public $settings;

  /*
   * @type Long
   */
  public $expectedId;

  /*
   * @type String
   */
  public $owner;

  /*
   * @type String
   */
  public $orgUnitUid;

  /*
   * Constructor
   */
  public function __construct() {
    $this->name = "";
    $this->domainUid = "";
    $this->settings = array();
    $this->expectedId = null;
    $this->owner = "";
    $this->orgUnitUid = "";
  }

  public function toMap() {
    $data = array(    
        "name" => empty($this->name) ? null : $this->name,    
        "domainUid" => empty($this->domainUid) ? null : $this->domainUid,    
        "settings" => empty($this->settings) ? null : $this->settings,    
        "expectedId" => empty($this->expectedId) ? null : $this->expectedId,    
        "owner" => empty($this->owner) ? null : $this->owner,    
        "orgUnitUid" => empty($this->orgUnitUid) ? null : $this->orgUnitUid);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
