/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.IFreebusyMgmt.
 */

goog.provide('net.bluemind.calendar.api.FreebusyMgmtVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.IFreebusyMgmt API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.FreebusyMgmtVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/mgmt/freebusy/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.calendar.api.FreebusyMgmtVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.calendar.api.FreebusyMgmtVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} calendar
 * @return {Object}
 */
net.bluemind.calendar.api.FreebusyMgmtVertxClient.prototype.add = function( calendar  ) {

  var postUri = "/{calendar}";

  postUri = postUri.replace("{calendar}", goog.string.urlEncode(calendar));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.FreebusyMgmtVertxClient.prototype.get = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} calendar
 * @return {Object}
 */
net.bluemind.calendar.api.FreebusyMgmtVertxClient.prototype.remove = function( calendar  ) {

  var postUri = "/{calendar}";

  postUri = postUri.replace("{calendar}", goog.string.urlEncode(calendar));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} calendars
 * @return {Object}
 */
net.bluemind.calendar.api.FreebusyMgmtVertxClient.prototype.set = function( calendars  ) {

  var postUri = "";

  var params = {};



  var body = null;
  body = calendars;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

