/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.ICalendarView.
 */

goog.provide('net.bluemind.calendar.api.CalendarViewVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.ICalendarView API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.CalendarViewVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/calendars/view/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.calendar.api.CalendarViewVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} view
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.create = function( uid ,  view  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = view;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.list = function() {

  var postUri = "/_list";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.setDefault = function( uid  ) {

  var postUri = "/{uid}/_asdefault";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} view
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.update = function( uid ,  view  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = view;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarViewVertxClient.prototype.updates = function( changes  ) {

  var postUri = "/_mupdates";

  var params = {};



  var body = null;
  body = changes;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

