/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.ICalendars.
 */

goog.provide('net.bluemind.calendar.api.CalendarsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.ICalendars API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.CalendarsVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/calendars';
};

goog.inherits(net.bluemind.calendar.api.CalendarsVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {Object} range
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsVertxClient.prototype.multipleGetByRange = function( range  ) {

  var postUri = "/_mget_range";

  var params = {};



  var body = null;
  body = range;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsVertxClient.prototype.search = function( query  ) {

  var postUri = "/_search";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} calendars
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsVertxClient.prototype.searchPendingCounters = function( calendars  ) {

  var postUri = "/_search_counters";

  var params = {};



  var body = null;
  body = calendars;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

