/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.ICalendarsMgmt.
 */

goog.provide('net.bluemind.calendar.api.CalendarsMgmtClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.ICalendarsMgmt API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.CalendarsMgmtClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/mgmt/calendars';
};

goog.inherits(net.bluemind.calendar.api.CalendarsMgmtClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsMgmtClient.prototype.create = function( uid ,  descriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsMgmtClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsMgmtClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getComplete_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsMgmtClient.prototype.reindex = function( containerUid  ) {

  var postUri = "/{containerUid}/_reindex";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "reindex_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsMgmtClient.prototype.reindexAll = function() {

  var postUri = "/_reindex";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "reindexAll_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarsMgmtClient.prototype.update = function( uid ,  descriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

