/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.ICalendarSettings.
 */

goog.provide('net.bluemind.calendar.api.CalendarSettingsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.ICalendarSettings API.
 * @param {string sessionId} sessionId
*  @param {string} calendarUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.CalendarSettingsVertxClient = function( sessionId , calendarUid ) {
  this.sessionId = sessionId;
  this.base = '/calendars/{calendarUid}/_config';
  this.calendarUid_ = calendarUid;
  this.base = this.base.replace('{calendarUid}',goog.string.urlEncode(calendarUid));
};

goog.inherits(net.bluemind.calendar.api.CalendarSettingsVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} calendarUid
 * @private
 */
net.bluemind.calendar.api.CalendarSettingsVertxClient.prototype.calendarUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarSettingsVertxClient.prototype.get = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} settings
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarSettingsVertxClient.prototype.set = function( settings  ) {

  var postUri = "";

  var params = {};



  var body = null;
  body = settings;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

