/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.IVFreebusy.
 */

goog.provide('net.bluemind.calendar.api.VFreebusyVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.IVFreebusy API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.VFreebusyVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/calendars/vfreebusy/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.calendar.api.VFreebusyVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.calendar.api.VFreebusyVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.VFreebusyVertxClient.prototype.get = function( query  ) {

  var postUri = "";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.VFreebusyVertxClient.prototype.getAsString = function( query  ) {

  var postUri = "/_ics";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

