/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.IPublishCalendar.
 */

goog.provide('net.bluemind.calendar.api.PublishCalendarVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.IPublishCalendar API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.PublishCalendarVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/calendars/publish/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.calendar.api.PublishCalendarVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.calendar.api.PublishCalendarVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} mode
 * @param {string} token
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarVertxClient.prototype.createUrl = function( mode ,  token  ) {

  var postUri = "/_create/{mode}";

  postUri = postUri.replace("{mode}", goog.string.urlEncode(mode));
  var params = {};

  if (goog.isDefAndNotNull(token)) {
    params['token'] = token;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} url
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarVertxClient.prototype.disableUrl = function( url  ) {

  var postUri = "/_disable";

  var params = {};



  var body = null;
  body = url;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} mode
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarVertxClient.prototype.generateUrl = function( mode  ) {

  var postUri = "/_generate/{mode}";

  postUri = postUri.replace("{mode}", goog.string.urlEncode(mode));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} mode
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarVertxClient.prototype.getGeneratedUrls = function( mode  ) {

  var postUri = "/generated/{mode}";

  postUri = postUri.replace("{mode}", goog.string.urlEncode(mode));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} token
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarVertxClient.prototype.publish = function( token  ) {

  var postUri = "/{token}";

  postUri = postUri.replace("{token}", goog.string.urlEncode(token));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

