/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.IPublishCalendar.
 */

goog.provide('net.bluemind.calendar.api.PublishCalendarClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.IPublishCalendar API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} containerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.PublishCalendarClient = function(rpc, base , containerUid ) {
  goog.base(this, rpc, base);
  this.base += '/calendars/publish/{containerUid}';
   this.containerUid_ = containerUid;
   this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.calendar.api.PublishCalendarClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.calendar.api.PublishCalendarClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} mode
 * @param {string} token
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarClient.prototype.createUrl = function( mode ,  token  ) {

  var postUri = "/_create/{mode}";

  postUri = postUri.replace("{mode}", goog.string.urlEncode(mode));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(token)) {
    url.getQueryData().add('token', token);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "createUrl_" 
                                  + this.containerUid_
                                  + mode
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} url
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarClient.prototype.disableUrl = function( url  ) {

  var postUri = "/_disable";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "disableUrl_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = url;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} mode
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarClient.prototype.generateUrl = function( mode  ) {

  var postUri = "/_generate/{mode}";

  postUri = postUri.replace("{mode}", goog.string.urlEncode(mode));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "generateUrl_" 
                                  + this.containerUid_
                                  + mode
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} mode
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarClient.prototype.getGeneratedUrls = function( mode  ) {

  var postUri = "/generated/{mode}";

  postUri = postUri.replace("{mode}", goog.string.urlEncode(mode));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getGeneratedUrls_" 
                                  + this.containerUid_
                                  + mode
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} token
 * @return {Object}
 */
net.bluemind.calendar.api.PublishCalendarClient.prototype.publish = function( token  ) {

  var postUri = "/{token}";

  postUri = postUri.replace("{token}", goog.string.urlEncode(token));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "publish_" 
                                  + this.containerUid_
                                  + token
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

