/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.IPublicFreebusy.
 */

goog.provide('net.bluemind.calendar.api.PublicFreebusyVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.IPublicFreebusy API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.PublicFreebusyVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/calendars/sfreebusy';
};

goog.inherits(net.bluemind.calendar.api.PublicFreebusyVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @param {string} callerUserUid
 * @param {string} callerDomain
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.PublicFreebusyVertxClient.prototype.get = function( email ,  callerUserUid ,  callerDomain ,  query  ) {

  var postUri = "/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));
  var params = {};

  if (goog.isDefAndNotNull(callerUserUid)) {
    params['callerUserUid'] = callerUserUid;
  }
  if (goog.isDefAndNotNull(callerDomain)) {
    params['callerDomain'] = callerDomain;
  }


  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @param {string} callerUserUid
 * @param {string} callerDomain
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.PublicFreebusyVertxClient.prototype.getAsString = function( email ,  callerUserUid ,  callerDomain ,  query  ) {

  var postUri = "/{email}/_ics";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));
  var params = {};

  if (goog.isDefAndNotNull(callerUserUid)) {
    params['callerUserUid'] = callerUserUid;
  }
  if (goog.isDefAndNotNull(callerDomain)) {
    params['callerDomain'] = callerDomain;
  }


  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @param {string} callerUserUid
 * @param {string} callerDomain
 * @return {Object}
 */
net.bluemind.calendar.api.PublicFreebusyVertxClient.prototype.simple = function( email ,  callerUserUid ,  callerDomain  ) {

  var postUri = "/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));
  var params = {};

  if (goog.isDefAndNotNull(callerUserUid)) {
    params['callerUserUid'] = callerUserUid;
  }
  if (goog.isDefAndNotNull(callerDomain)) {
    params['callerDomain'] = callerDomain;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

