/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.IPublicFreebusy.
 */

goog.provide('net.bluemind.calendar.api.PublicFreebusyClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.IPublicFreebusy API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.PublicFreebusyClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/calendars/sfreebusy';
};

goog.inherits(net.bluemind.calendar.api.PublicFreebusyClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @param {string} callerUserUid
 * @param {string} callerDomain
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.PublicFreebusyClient.prototype.get = function( email ,  callerUserUid ,  callerDomain ,  query  ) {

  var postUri = "/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(callerUserUid)) {
    url.getQueryData().add('callerUserUid', callerUserUid);
  }
  if (goog.isDefAndNotNull(callerDomain)) {
    url.getQueryData().add('callerDomain', callerDomain);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + email
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @param {string} callerUserUid
 * @param {string} callerDomain
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.PublicFreebusyClient.prototype.getAsString = function( email ,  callerUserUid ,  callerDomain ,  query  ) {

  var postUri = "/{email}/_ics";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(callerUserUid)) {
    url.getQueryData().add('callerUserUid', callerUserUid);
  }
  if (goog.isDefAndNotNull(callerDomain)) {
    url.getQueryData().add('callerDomain', callerDomain);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "getAsString_" 
                                  + email
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @param {string} callerUserUid
 * @param {string} callerDomain
 * @return {Object}
 */
net.bluemind.calendar.api.PublicFreebusyClient.prototype.simple = function( email ,  callerUserUid ,  callerDomain  ) {

  var postUri = "/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(callerUserUid)) {
    url.getQueryData().add('callerUserUid', callerUserUid);
  }
  if (goog.isDefAndNotNull(callerDomain)) {
    url.getQueryData().add('callerDomain', callerDomain);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "simple_" 
                                  + email
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

