/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.ICalendar.
 */

goog.provide('net.bluemind.calendar.api.CalendarVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.ICalendar API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.CalendarVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/calendars/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.calendar.api.CalendarVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.all = function() {

  var postUri = "/_all";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.changesetById = function( since  ) {

  var postUri = "/_changesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.count = function( arg0  ) {

  var postUri = "/_count";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} event
 * @param {boolean} sendNotifications
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.create = function( uid ,  event ,  sendNotifications  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};

  if (goog.isDefAndNotNull(sendNotifications)) {
    params['sendNotifications'] = sendNotifications;
  }


  var body = null;
  body = event;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.createById = function( id ,  arg1  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {boolean} sendNotifications
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.delete_ = function( uid ,  sendNotifications  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};

  if (goog.isDefAndNotNull(sendNotifications)) {
    params['sendNotifications'] = sendNotifications;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.deleteById = function( id  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.filteredChangesetById = function( since ,  arg1  ) {

  var postUri = "/_filteredChangesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.getByIcsUid = function( uid  ) {

  var postUri = "/_icsuid/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.getCompleteById = function( id  ) {

  var postUri = "/{id}/completeById";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.getVersion = function() {

  var postUri = "/_version";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.isAutoSyncActivated = function() {

  var postUri = "/_isAutoSyncActivated";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {number} arg1
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.itemChangelog = function( uid ,  arg1  ) {

  var postUri = "/{uid}/_itemchangelog";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.list = function() {

  var postUri = "/_list";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} arg0
 * @param {boolean} bypassDeletedItems
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.multipleDeleteById = function( arg0 ,  bypassDeletedItems  ) {

  var postUri = "/_multipleDelete";

  var params = {};

  if (goog.isDefAndNotNull(bypassDeletedItems)) {
    params['bypassDeletedItems'] = bypassDeletedItems;
  }


  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} arg0
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.multipleGetById = function( arg0  ) {

  var postUri = "/_mgetById";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.reset = function() {

  var postUri = "/_reset";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.search = function( query  ) {

  var postUri = "/_search";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.searchPendingCounters = function() {

  var postUri = "/_search_counters";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.sortedIds = function( arg0  ) {

  var postUri = "/_sorted";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.sortedUids = function( arg0  ) {

  var postUri = "/_sorteduids";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.sync = function( since ,  changes  ) {

  var postUri = "/_sync";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  body = changes;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.touch = function( uid  ) {

  var postUri = "/{uid}/_touch";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} event
 * @param {boolean} sendNotifications
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.update = function( uid ,  event ,  sendNotifications  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};

  if (goog.isDefAndNotNull(sendNotifications)) {
    params['sendNotifications'] = sendNotifications;
  }


  var body = null;
  body = event;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.updateById = function( id ,  arg1  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarVertxClient.prototype.updates = function( changes  ) {

  var postUri = "/_mupdates";

  var params = {};



  var body = null;
  body = changes;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

