/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.IUserCalendarViews.
 */

goog.provide('net.bluemind.calendar.api.UserCalendarViewsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.IUserCalendarViews API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
*  @param {string} userUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient = function( sessionId , domainUid , userUid ) {
  this.sessionId = sessionId;
  this.base = '/users/{domainUid}/{userUid}/calendar-views';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
  this.userUid_ = userUid;
  this.base = this.base.replace('{userUid}',goog.string.urlEncode(userUid));
};

goog.inherits(net.bluemind.calendar.api.UserCalendarViewsVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.domainUid_;
/**
 * @type {string} userUid
 * @private
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.userUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.changesetById = function( since  ) {

  var postUri = "/_changesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} view
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.create = function( uid ,  view  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = view;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.filteredChangesetById = function( since ,  arg1  ) {

  var postUri = "/_filteredChangesetById";

  var params = {};

  if (goog.isDefAndNotNull(since)) {
    params['since'] = since;
  }


  var body = null;
  body = arg1;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.getCompleteById = function( id  ) {

  var postUri = "/{id}/completeById";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.getVersion = function() {

  var postUri = "/_version";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.list = function() {

  var postUri = "/_list";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";

  var params = {};



  var body = null;
  body = uids;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} arg0
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.multipleGetById = function( arg0  ) {

  var postUri = "/_mgetById";

  var params = {};



  var body = null;
  body = arg0;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.setDefault = function( uid  ) {

  var postUri = "/{uid}/_asdefault";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} view
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.update = function( uid ,  view  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = view;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.calendar.api.UserCalendarViewsVertxClient.prototype.updates = function( changes  ) {

  var postUri = "/_mupdates";

  var params = {};



  var body = null;
  body = changes;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

