/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.ICalendarSettings.
 */

goog.provide('net.bluemind.calendar.api.CalendarSettingsClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.ICalendarSettings API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} calendarUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.CalendarSettingsClient = function(rpc, base , calendarUid ) {
  goog.base(this, rpc, base);
  this.base += '/calendars/{calendarUid}/_config';
   this.calendarUid_ = calendarUid;
   this.base = this.base.replace('{calendarUid}',goog.string.urlEncode(calendarUid));
};

goog.inherits(net.bluemind.calendar.api.CalendarSettingsClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} calendarUid
 * @private
 */
net.bluemind.calendar.api.CalendarSettingsClient.prototype.calendarUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarSettingsClient.prototype.get = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + this.calendarUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} settings
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarSettingsClient.prototype.set = function( settings  ) {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "set_" 
                                  + this.calendarUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = settings;
  return this.execute(cmd, body);
};

