/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.calendar.api.ICalendarAutocomplete.
 */

goog.provide('net.bluemind.calendar.api.CalendarAutocompleteVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.calendar.api.ICalendarAutocomplete API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.calendar.api.CalendarAutocompleteVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/calendar/autocomplete';
};

goog.inherits(net.bluemind.calendar.api.CalendarAutocompleteVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} groupUid
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarAutocompleteVertxClient.prototype.calendarGroupLookup = function( groupUid  ) {

  var postUri = "/_calendarsGroupLookup/{groupUid}";

  postUri = postUri.replace("{groupUid}", goog.string.urlEncode(groupUid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} pattern
 * @param {Object} verb
 * @return {Object}
 */
net.bluemind.calendar.api.CalendarAutocompleteVertxClient.prototype.calendarLookup = function( pattern ,  verb  ) {

  var postUri = "/_calendarLookup/{pattern}";

  postUri = postUri.replace("{pattern}", goog.string.urlEncode(pattern));
  var params = {};



  var body = null;
  body = verb;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

