/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.memory.pool.api;

import java.util.List;

import net.bluemind.eclipse.common.RunnableExtensionLoader;

public class Pools {

	private Pools() {
	}

	public static IPoolFactory factory() {
		RunnableExtensionLoader<IPoolFactory> rel = new RunnableExtensionLoader<IPoolFactory>();
		List<IPoolFactory> list = rel.loadExtensionsWithPriority("net.bluemind.memory.pool.api", "provider", "provider",
				"impl");
		if (list.isEmpty()) {
			throw new UnsupportedOperationException("No pool impl found");
		}
		return list.getFirst();
	}

}
