package net.bluemind.keydb.common;

import java.util.function.Supplier;

import com.google.common.base.Suppliers;

import net.bluemind.eclipse.common.RunnableExtensionLoader;

public class KeydbBootstrapNetAddress {

	private static final Supplier<IKeydbBootstrap> keydbAddressResolver = Suppliers
			.memoize(() -> loadKeydbAddressResolver());

	private KeydbBootstrapNetAddress() {
	}

	private static IKeydbBootstrap loadKeydbAddressResolver() {
		RunnableExtensionLoader<IKeydbBootstrap> extensionLoader = new RunnableExtensionLoader<>();
		return extensionLoader.loadExtensionsWithPriority("net.bluemind.keydb.common", "resolver", "resolver", "impl")
				.stream().filter(IKeydbBootstrap::isAvailable).findFirst().orElse(null);
	}

	public static String getKeydbIP() {
		return keydbAddressResolver.get().keydbHost();
	}

}
