/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2024
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.hornetq.client;

import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.vertx.core.json.JsonObject;

public class Producer {

	private final RedisPubSubAsyncCommands<String, JsonObject> publisher;
	private final String channel;

	public Producer(RedisPubSubAsyncCommands<String, JsonObject> redisPubSubAsyncCommands, String channel) {
		this.publisher = redisPubSubAsyncCommands;
		this.channel = channel;
	}

	public void send(OOPMessage message) {
		publisher.publish(this.channel, message.toJson());
	}

	public void send(JsonObject message) {
		publisher.publish(this.channel, message);
	}

	/**
	 * Calling it is not mandatory, redis-based producers do not hold resources
	 */
	public void close() {
		// not needed for now as we don't hold any resource
	}
}
