package net.bluemind.exchange.mapi.api;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class MapiPidMapping {

	public static final String TYPE = "pid";

	private int id;
	private String name;

	public MapiPidMapping() {

	}

	public MapiPidMapping(int id, String name) {
		this.id = id;
		this.name = name;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public void setId(int id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(MapiPidMapping.class).add("id", id).add("name", name).toString();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof MapiPidMapping mapping) {
			return Objects.equals(mapping.id, id) && Objects.equals(mapping.name, name);
		}
		return super.equals(obj);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, name);
	}
}
