/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class RestoreOperation {

	public String identifier;
	public RestorableKind kind;
	public String requiredTag;

	public static RestoreOperation forKind(String identifier, RestorableKind kind) {
		RestoreOperation restoreOperation = new RestoreOperation();
		restoreOperation.identifier = identifier;
		restoreOperation.kind = kind;
		return restoreOperation;
	}

	public static RestoreOperation forKind(String identifier, RestorableKind kind, String tag) {
		RestoreOperation restoreOperation = forKind(identifier, kind);
		restoreOperation.requiredTag = tag;
		return restoreOperation;
	}

	@Override
	public String toString() {
		return "RestoreOperation: identifier: " + identifier + ", requiredTag: " + requiredTag + ", kind: " + kind;
	}
}
