/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.rest.vertx;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import net.bluemind.core.rest.base.RestRootHandler;

public class RestBusVerticle extends AbstractVerticle {

	@Override
	public void start(Promise<Void> startPromise) throws Exception {
		RestRootHandler rrHandler = new RestRootHandler(vertx);
		vertx.eventBus().consumer("bm-core", new RestVertxRootHandler(vertx, rrHandler));
		vertx.eventBus().consumer("bm-core-json", new RestJsonVertxRootHandler(vertx, rrHandler));
		startPromise.complete();
	}

}
