package net.bluemind.core.container.api;

import java.util.List;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import net.bluemind.core.api.BMApi;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.SharedContainer;

@BMApi(version = "3")
@Path("/containers/{domainUid}/{ownerUid}/_shared")
public interface ISharedContainers {

	/**
	 * Get all Containers
	 * ({@link net.bluemind.core.container.model.SharedContainer}) shared by
	 * ownerUid
	 * 
	 * @param type the container's type
	 * @return a list of containers for the given type and their
	 *         {@link net.bluemind.core.container.model.acl.AccessControlEntry}
	 *         information
	 * @throws ServerFault standard error object (unchecked exception)
	 */
	@GET()
	public List<SharedContainer> getSharedContainers(@QueryParam("type") String type) throws ServerFault;
}
