package net.bluemind.keydb.common;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.core.utils.JsonUtils.ValueWriter;

// TODO is there more efficient serdes than json jackson (protobuff, ObjectInputStream, ...)?
public class ObjectCodec<T extends Object> implements RedisCodec<String, T> {
	private Charset charset = StandardCharsets.UTF_8;
	private StringCodec utf8Codec = StringCodec.UTF8;
	private ValueReader<T> jsonReader;
	private ValueWriter jsonWriter;

	public ObjectCodec(Class<T> typeParameterClass) {
		jsonWriter = JsonUtils.writer(typeParameterClass);
		jsonReader = JsonUtils.reader(typeParameterClass);
	}

	@Override
	public String decodeKey(ByteBuffer bytes) {
		return utf8Codec.decodeKey(bytes);
	}

	@Override
	public T decodeValue(ByteBuffer bytes) {
		return jsonReader.read(charset.decode(bytes).toString());
	}

	@Override
	public ByteBuffer encodeKey(String key) {
		return utf8Codec.encodeKey(key);
	}

	@Override
	public ByteBuffer encodeValue(T value) {
		return ByteBuffer.wrap(jsonWriter.write(value));
	}
}