/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import net.bluemind.core.api.BMApi;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.api.IRestoreCrudSupport;
import net.bluemind.core.container.model.ContainerDescriptor;
import net.bluemind.core.task.api.TaskRef;

/**
 * Todolist indexing API
 *
 */
@BMApi(version = "3")
@Path("/mgmt/todolists")
public interface ITodoListsMgmt extends IRestoreCrudSupport<ContainerDescriptor> {

	/**
	 * Reindex all Todolists
	 *
	 * @return {@link net.bluemind.core.task.api.TaskRef} which can be used to track
	 *         this asynchronous operation
	 * @throws ServerFault
	 */
	@POST
	@Path("_reindex")
	public TaskRef reindexAll() throws ServerFault;

	/**
	 * Reindex a Todolist
	 *
	 * @param todoUid Unique Todolist ID
	 * @return {@link net.bluemind.core.task.api.TaskRef} which can be used to track
	 *         this asynchronous operation
	 * @throws ServerFault
	 */
	@POST
	@Path("{containerUid}/_reindex")
	public TaskRef reindex(@PathParam("containerUid") String todoUid) throws ServerFault;

	@Path("{containerUid}")
	@PUT
	public void create(@PathParam("containerUid") String uid, ContainerDescriptor descriptor,
			@QueryParam("isDefault") boolean isDefault) throws ServerFault;

	@Path("{containerUid}")
	@POST
	void update(@PathParam("containerUid") String uid, ContainerDescriptor descriptor) throws ServerFault;

	@Path("{containerUid}")
	@GET
	ContainerDescriptor getComplete(@PathParam("containerUid") String uid) throws ServerFault;

}
