/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2024
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.keydb.common;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import io.lettuce.core.codec.RedisCodec;
import io.vertx.core.json.JsonObject;

public class JsonRedisCodec implements RedisCodec<String, JsonObject> {
	private Charset charset = StandardCharsets.UTF_8;

	@Override
	public ByteBuffer encodeValue(JsonObject value) {
		return ByteBuffer.wrap(value.encode().getBytes());
	}

	@Override
	public ByteBuffer encodeKey(String key) {
		return ByteBuffer.wrap(key.getBytes());
	}

	@Override
	public JsonObject decodeValue(ByteBuffer bytes) {
		return new JsonObject(charset.decode(bytes).toString());
	}

	@Override
	public String decodeKey(ByteBuffer bytes) {
		return charset.decode(bytes).toString();
	}
}
