package net.bluemind.exchange.mapi.api;

import java.util.Objects;
import java.util.UUID;

public class MapiPCLCacheEntry {

	public static final int SHORT_SIZE = 20;
	public static final int LONG_SIZE = 22;
	private long modificationNanos;
	private UUID serverReplicaGuid;
	private long version;
	private int changekeySize;

	public MapiPCLCacheEntry(long modificationNanos, UUID serverReplicaGuid, long version, int changekeySize) {
		this.modificationNanos = modificationNanos;
		this.serverReplicaGuid = serverReplicaGuid;
		this.version = version;
		this.changekeySize = changekeySize;
	}

	public MapiPCLCacheEntry() {
	}

	public long getModificationNanos() {
		return modificationNanos;
	}

	public void setModificationNanos(long modificationNanos) {
		this.modificationNanos = modificationNanos;
	}

	public UUID getServerReplicaGuid() {
		return serverReplicaGuid;
	}

	public void setServerReplicaGuid(UUID serverReplicaGuid) {
		this.serverReplicaGuid = serverReplicaGuid;
	}

	public long getVersion() {
		return version;
	}

	public void setVersion(long version) {
		this.version = version;
	}

	public int getChangekeySize() {
		return changekeySize;
	}

	public void setChangekeySize(int changekeySize) {
		this.changekeySize = changekeySize;
	}

	@Override
	public int hashCode() {
		return Objects.hash(modificationNanos, serverReplicaGuid, version, changekeySize);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		MapiPCLCacheEntry other = (MapiPCLCacheEntry) obj;
		return modificationNanos == other.modificationNanos
				&& Objects.equals(serverReplicaGuid, other.serverReplicaGuid) && version == other.version
				&& changekeySize == other.changekeySize;
	}

	@Override
	public String toString() {
		return "MapiPCLCacheEntry [modificationNanos=" + modificationNanos + ", serverReplicaGuid=" + serverReplicaGuid
				+ ", version=" + version + ", changekeySize=" + changekeySize + "]";
	}

}
