package net.bluemind.core.sessions;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.config.Token;
import net.bluemind.core.context.SecurityContext;

public class Sessions {
	public static final Logger logger = LoggerFactory.getLogger(Sessions.class);
	private static final ISessionsStore STORE = buildStore();

	private Sessions() {
	}

	private static ISessionsStore buildStore() {
		return SessionsStoreFactory.get();
	}

	public static final ISessionsStore get() {
		return STORE;
	}

	public static SecurityContext sessionContext(String key) {
		if (key == null) {
			return null;
		}
		if (key.equals(Token.admin0())) {
			return SecurityContext.SYSTEM;
		}

		return Optional.ofNullable(STORE.getIfPresent(key)).orElseGet(() -> {
			for (ISessionsProvider sp : SessionProviders.get()) {
				SecurityContext fromProv = sp.get(key).orElse(null);
				if (fromProv != null) {
					// prevent rebuild from provider
					STORE.put(key, fromProv);
					return fromProv;
				}
			}

			return null;
		});
	}
}
