/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.common.vertx.contextlogging;

import java.util.Map;

import net.bluemind.common.context.ContextAccess;

public class ContextAccessAdapter implements ContextAccess {

	@Override
	public Map<String, String> getAll() {
		return ContextualData.getAll();
	}

	@Override
	public void put(String k, String v) {
		ContextualData.put(k, v);
	}

	@Override
	public String get(String k) {
		return ContextualData.get(k);
	}

	@Override
	public String getOrDefault(String k, String v) {
		return ContextualData.getOrDefault(k, v);
	}

	@Override
	public void remove(String k) {
		ContextualData.remove(k);
	}

}
