/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.keydb.common;

import java.util.function.Supplier;

import com.google.common.base.Suppliers;

import io.lettuce.core.RedisClient;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;

public class ClientProvider {

	public static String NOTIFY_KEYSPACE_EVENTCONFIG = "KE$x";

	static {
		System.setProperty("io.lettuce.core.iouring", "false");
	}

	private static final Supplier<ClientResources> nettyRes = Suppliers.memoize(DefaultClientResources::create);

	private static final Supplier<String> redisUri = Suppliers
			.memoize(() -> toUri(KeydbBootstrapNetAddress.getKeydbIP()));

	private ClientProvider() {

	}

	public static RedisClient newClient() {
		return RedisClient.create(nettyRes.get(), redisUri.get());
	}

	public static RedisClient newClient(String ipOrUri) {
		return RedisClient.create(nettyRes.get(), toUri(ipOrUri));
	}

	private static String toUri(String ipOrUri) {
		if (ipOrUri.contains("://")) {
			return ipOrUri;
		}
		return "redis://" + ipOrUri + ":6379";
	}

}
