package net.bluemind.notes.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.notes.api.INoteAsync.class)
public interface INotePromise  {

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> all();

	CompletableFuture<java.util.List<java.lang.String>> allUids();

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0);

	CompletableFuture<Void> create(java.lang.String uid, net.bluemind.notes.api.VNote note);

	CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id, net.bluemind.notes.api.VNote arg1);

	CompletableFuture<Void> delete(java.lang.String uid);

	CompletableFuture<Void> deleteById(long id);

	CompletableFuture<net.bluemind.core.api.Stream> exportAll();

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> getCompleteById(long id);

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<Void> multipleDeleteById(java.util.List<java.lang.Long> arg0, java.lang.Boolean bypassDeletedItems);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> multipleGet(java.util.List<java.lang.String> uids);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<Void> reset();

	CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> search(net.bluemind.notes.api.VNoteQuery query);

	CompletableFuture<java.util.List<java.lang.Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<java.util.List<java.lang.String>> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<Void> update(java.lang.String uid, net.bluemind.notes.api.VNote note);

	CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id, net.bluemind.notes.api.VNote arg1);

	CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> updates(net.bluemind.notes.api.VNoteChanges changes);

}