/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.rest;

import java.io.File;
import java.util.List;
import java.util.Set;

import javax.sql.DataSource;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.context.SecurityContext;

public interface BmContext {

	public static final DataSourceType DEFAULT_FLAVOR = defaultFlavor();

	public static DataSourceType defaultFlavor() {
		DataSourceType ret = new File("/etc/bm/cql-persistence.conf").exists() || Boolean.getBoolean("cql.flavor")
				? DataSourceType.CQL
				: DataSourceType.POSTGRESQL;
		return ret;
	}

	public SecurityContext getSecurityContext();

	public DataSource getDataSource();

	public DataSource getMailboxDataSource(String datalocation);

	/**
	 * dir for for {@link BmContext#getDataSource()}
	 *
	 * datalocation matching {@link BmContext#getMailboxDataSource(String)}
	 *
	 * null when unknown
	 *
	 * @param ds
	 * @return
	 */
	public String dataSourceLocation(DataSource ds);

	public List<DataSource> getAllMailboxDataSource();

	default List<String> mailboxLocations() {
		return getAllMailboxDataSource().stream().map(this::dataSourceLocation).toList();
	}

	@Deprecated(forRemoval = true)
	/**
	 * Duplicates {@link BmContext#provider}, will be removed in Bluemind version 6
	 *
	 * @return
	 */
	public IServiceProvider getServiceProvider();

	public IServiceProvider provider();

	public BmContext su(SecurityContext ctx);

	public BmContext su();

	public BmContext su(String userUid, String domainUid);

	public BmContext su(String sid, String userUid, String domainUid);

	public BmContext withRoles(Set<String> roles);

	default DataSourceType getStorageFlavor() {
		return Boolean.getBoolean("cql.flavor") ? DataSourceType.CQL : DEFAULT_FLAVOR;
	}
}
