/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.api;

import net.bluemind.core.api.BMApi;
import net.bluemind.core.container.model.ItemValue;

@BMApi(version = "3")
public class FolderCounters {

	/**
	 * internalId of the {@link ItemValue} {@link MailboxFolder}
	 */
	public long itemId;

	/**
	 * Version of the matching mbox_records container
	 */
	public long recordsVersion;

	public int unseenVisible;
	public int totalVisible;
	public int total;

	@Override
	public String toString() {
		return "Counter{f:" + itemId + ", v: " + recordsVersion + ", uv: " + unseenVisible + "}";
	}
}
