/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api;

import java.util.List;

import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import net.bluemind.core.api.BMApi;
import net.bluemind.core.api.ListResult;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.ItemContainerValue;

@BMApi(version = "3")
@Path("/addressbooks")
public interface IAddressBooks {

	/**
	 * ElasticSearch based vcard search througth all subscribed addressbooks
	 * 
	 * @param query
	 * @return
	 * @throws ServerFault
	 */
	@POST
	@Path("_search")
	public ListResult<ItemContainerValue<VCardInfo>> search(VCardQuery query) throws ServerFault;

	/**
	 * 
	 * 
	 * @param email
	 * @return a list of itemId as strings
	 * @throws ServerFault
	 */
	@POST
	@Path("_findUidsByEmail")
	public List<String> findUidsByEmail(String email) throws ServerFault;

	/**
	 * Look up certificates for the given email in all subscribed addressbooks
	 * 
	 * This operation is suitable to look up usable smime certs to encrypt a message
	 * for a recipient.
	 * 
	 * @param email
	 * @return
	 * @throws ServerFault
	 */
	@POST
	@Path("_findCertsByEmail")
	public List<CertInfo> findCertsByEmail(@QueryParam("email") String email) throws ServerFault;

}
