package net.bluemind.exchange.mapi.api;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import net.bluemind.core.api.BMApi;

@BMApi(version = "3", internal = true)
@Path("/mapi_pclcache")
public interface IMapiPCLCache {

	@GET
	@Path("entry/{replicaGuid}/{globalCounter}")
	public MapiPCLCacheEntry get(@PathParam("replicaGuid") String replicaGuid,
			@PathParam("globalCounter") Long globalCounter);

	@PUT
	@Path("entry/{replicaGuid}/{globalCounter}")
	public void store(@PathParam("replicaGuid") String replicaGuid, @PathParam("globalCounter") Long globalCounter,
			MapiPCLCacheEntry entry);

	@GET
	@Path("entry/contains/{replicaGuid}/{globalCounter}")
	public boolean contains(@PathParam("replicaGuid") String replicaGuid,
			@PathParam("globalCounter") Long globalCounter);

	@DELETE
	@Path("entry/{replicaGuid}/{globalCounter}")
	public void delete(@PathParam("replicaGuid") String replicaGuid, @PathParam("globalCounter") Long globalCounter);
}
