/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.api;

import java.util.stream.Stream;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public enum WorkerDataType {
	PG("pg"), DIRECTORY_LEGACY("directory"), DIRECTORY("directory-json"), NOTES("notes"), CONFIG("configuration"),
	CALENDAR("calendar"), ADDRESSBOOK("addressbook"), TODOLIST("todolist"), SDS_SPOOL("sds-spool"), SDS("sds"),
	WEBAPPDATA("webappdata"), ELASTICSEARCH("es"), FILEHOSTING("filehosting");

	public final String value;

	private WorkerDataType(String value) {
		this.value = value;
	}

	public static WorkerDataType fromValue(String value) {
		return Stream.of(WorkerDataType.values()).filter(v -> v.value.equalsIgnoreCase(value)).findFirst().orElse(null);
	}

}
