/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.api;

import net.bluemind.core.api.BMApi;
import net.bluemind.core.api.fault.ErrorCode;
import net.bluemind.core.container.model.ContainerUpdatesResult;

@BMApi(version = "3")
public final class DPError {

	@BMApi(version = "3")
	public enum RestoreType {
		RESTORE, EXPORT;
	}

	@BMApi(version = "3")
	public enum DPKind {
		ADDRESSBOOK, CALENDAR, USER, MAILSHARE, DOMAIN_ADDRESSBOOK, DOMAIN_CALENDAR, TODOLISTS, WEBAPPDATA, NOTES,
		RESOURCE;
	}

	public String message;
	public String uid;
	public RestoreType type;
	public DPKind kind;
	public ErrorCode errorCode;

	private static DPError create(String message, ErrorCode errorCode, String uid, RestoreType type, DPKind kind) {
		DPError ret = new DPError();
		ret.message = message;
		ret.uid = uid;
		ret.errorCode = errorCode;
		ret.type = type;
		ret.kind = kind;
		return ret;
	}

	public static DPError createUnknown(String message, String uid, RestoreType type, DPKind kind) {
		return DPError.create(message, ErrorCode.UNKNOWN, uid, type, kind);
	}

	public static DPError restore(String message, String uid, DPKind kind) {
		return DPError.create(message, ErrorCode.UNKNOWN, uid, RestoreType.RESTORE, kind);
	}

	public static DPError export(String message, String uid, DPKind kind) {
		return DPError.create(message, ErrorCode.UNKNOWN, uid, RestoreType.EXPORT, kind);
	}

	public static DPError export(String message, String uid) {
		return DPError.create(message, ErrorCode.UNKNOWN, uid, RestoreType.EXPORT, null);
	}

	public static DPError export(String message, ErrorCode errorCode, String uid) {
		return DPError.create(message, errorCode, uid, RestoreType.EXPORT, null);
	}

	public static DPError createRestore(ContainerUpdatesResult.InError error) {
		return DPError.create(error.message, error.errorCode, error.uid, RestoreType.RESTORE, null);
	}

	@Override
	public String toString() {
		return "Error " + errorCode + " on: " + type + " for uid: " + uid + "(" + kind + ") : " + message;
	}
}
