/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.internal;

import java.util.Date;

import net.bluemind.core.container.model.ChangeLogEntry.Type;
import net.bluemind.core.container.model.ItemChangeLogEntry;

public class VEventHistory {

	public enum HistoryActionType {
		Created, Updated, Deleted;

		public static Type fromActionType(HistoryActionType type) {
			switch (type) {
			case Created:
				return Type.Created;
			case Updated:
				return Type.Updated;
			case Deleted:
				return Type.Deleted;
			default:
				throw new IllegalArgumentException("Unexpected value: " + type);
			}
		}
	}

	public long containerId;
	public long itemId;
	public String icsUid;

	public Date date;
	public String author;
	public HistoryActionType actionType;
	public String origin;

	@Override
	public String toString() {
		return "VEventHistory=[containerId = " + containerId + ", itemId = " + itemId + ", icsUid = " + icsUid + ", timestamp = " + date
				+ ", author = " + author + ", actionType = " + actionType.name() + ", origin = " + origin;
	}

	public ItemChangeLogEntry toItemChangeLogEntry(String itemUid) {
		ItemChangeLogEntry changeLogEntry = new ItemChangeLogEntry();
		changeLogEntry.author = author;
		changeLogEntry.origin = origin;
		changeLogEntry.itemUid = itemUid;
		changeLogEntry.type = HistoryActionType.fromActionType(actionType);
		changeLogEntry.date = date;
		return changeLogEntry;
	}
}
