package net.bluemind.backend.mail.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.backend.mail.api.IMailboxFoldersAsync.class)
public interface IMailboxFoldersPromise  {

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> all();

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> byName(java.lang.String name);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> childrensOf(java.lang.String folderUid);

	CompletableFuture<java.util.List<net.bluemind.backend.mail.api.FolderCounters>> counters(java.util.List<java.lang.Long> folderItemIds);

	CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> createBasic(net.bluemind.backend.mail.api.MailboxFolder value);

	CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> createForHierarchy(long hierarchyId, net.bluemind.backend.mail.api.MailboxFolder value);

	CompletableFuture<Void> deepDelete(long id);

	CompletableFuture<Void> deleteById(long id);

	CompletableFuture<Void> emptyFolder(long id);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getCompleteById(long id);

	CompletableFuture<java.lang.String> getFullName(java.lang.String uid);

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> importItems(long folderDestinationId, net.bluemind.backend.mail.api.ImportMailboxItemSet mailboxItems);

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<Void> markFolderAsRead(long id);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<Void> removeMessages(long id);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> root();

	CompletableFuture<net.bluemind.backend.mail.api.SearchResult> searchItems(net.bluemind.backend.mail.api.MailboxFolderSearchQuery query);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> trash();

	CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id, net.bluemind.backend.mail.api.MailboxFolder value);

}