/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.repository;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Optional;

import net.bluemind.backend.mail.api.MessageBody;
import net.bluemind.backend.mail.replica.api.ImapBinding;
import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.backend.mail.replica.api.MailboxRecordItemUri;
import net.bluemind.backend.mail.replica.api.RawImapBinding;
import net.bluemind.backend.mail.replica.api.RecordID;
import net.bluemind.backend.mail.replica.api.WithId;
import net.bluemind.core.container.api.Count;
import net.bluemind.core.container.model.CountFastPath;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.model.ItemFlagFilter;
import net.bluemind.core.container.model.SortDescriptor;
import net.bluemind.core.container.repository.IItemValueStore;

public interface IMailboxRecordStore extends IItemValueStore<MailboxRecord> {

	void create(Item item, MailboxRecord value) throws SQLException;

	void update(Item item, MailboxRecord value) throws SQLException;

	void delete(Item item) throws SQLException;

	MailboxRecord get(Item item) throws SQLException;

	void deleteAll() throws SQLException;

	/**
	 * Retrieve a collection of {@link RecordID} from an array of imap uids.
	 *
	 * @param uidArrays
	 * @return
	 * @throws SQLException
	 */
	List<RecordID> identifiers(long... uidArrays) throws SQLException;

	List<ImapBinding> bindings(List<Long> itemIds) throws SQLException;

	List<Long> sortedIds(boolean fastEnabled, SortDescriptor desc) throws SQLException;

	/**
	 * @return the list of {@link ImapBinding} for which the corresponding
	 *         {@link MessageBody} has a {@link MessageBody#bodyVersion} lower than
	 *         <code>version</code>
	 */
	List<ImapBinding> havingBodyVersionLowerThan(int version) throws SQLException;

	List<ImapBinding> recentItems(Date d) throws SQLException;

	List<ImapBinding> listItemsAfter(Date d) throws SQLException;

	List<ImapBinding> unreadItems() throws SQLException;

	Count count(ItemFlagFilter itemFilter) throws SQLException;

	Optional<Count> fastpathCount(CountFastPath fastPath);

	long weight() throws SQLException;

	// TODO: this query is a problem: access cross partitions
	List<MailboxRecordItemUri> getBodyGuidReferences(String guid) throws SQLException;

	String getImapUidReferences(long imapUid) throws SQLException;

	List<Long> getItemsByConversations(Long[] conversationIds) throws SQLException;

	List<RawImapBinding> imapIdset(String set, ItemFlagFilter itemFilter) throws SQLException;

	List<WithId<MailboxRecord>> slice(List<Long> itemIds) throws SQLException;

	List<WithId<MailboxRecord>> lightSlice(List<Long> itemIds) throws SQLException;

	List<String> labels() throws SQLException;

	boolean exists(Item item) throws SQLException;
}
