CREATE OR REPLACE FUNCTION fn_sync_message_body_purge_queue_insert()
RETURNS TRIGGER AS $$
BEGIN
    INSERT INTO tx_outbox_for_kafka(domain_uid, part_key, kafka_key, kafka_value)
    SELECT 
        'sync.q',
        'pq',
        convert_to(
            json_build_object(
                'type', 'pq',
                'owner', '',
                'id', -1,
                'uid', encode(n.message_body_guid, 'hex'),
                'valueClass', '',
                'operation', 'SYNC'
            )::text, 'UTF-8'
        ),
        convert_to(
            json_build_object(
                'created', (EXTRACT(EPOCH FROM n.created) * 1000)::bigint,
                'removed', (EXTRACT(EPOCH FROM n.removed) * 1000)::bigint,
                'immediate_remove', n.immediate_remove
            )::text, 'UTF-8'
        )
    FROM new_table n;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION fn_sync_message_body_purge_queue_update()
RETURNS TRIGGER AS $$
BEGIN
    INSERT INTO tx_outbox_for_kafka(domain_uid, part_key, kafka_key, kafka_value)
    SELECT 
        'sync.q',
        'pq',
        convert_to(
            json_build_object(
                'type', 'pq',
                'owner', '',
                'id', -1,
                'uid', encode(n.message_body_guid, 'hex'),
                'valueClass', '',
                'operation', 'SYNC'
            )::text, 'UTF-8'
        ),
        convert_to(
            json_build_object(
                'created', (EXTRACT(EPOCH FROM n.created) * 1000)::bigint,
                'removed', (EXTRACT(EPOCH FROM n.removed) * 1000)::bigint,
                'immediate_remove', n.immediate_remove
            )::text, 'UTF-8'
        )
    FROM new_table n;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION fn_sync_message_body_purge_queue_delete()
RETURNS TRIGGER AS $$
BEGIN
    INSERT INTO tx_outbox_for_kafka(domain_uid, part_key, kafka_key, kafka_value)
    SELECT 
        'sync.q',
        'pq',
        convert_to(
            json_build_object(
                'type', 'pq',
                'owner', '',
                'id', -1,
                'uid', encode(o.message_body_guid, 'hex'),
                'valueClass', '',
                'operation', 'SYNC'
            )::text, 'UTF-8'
        ),
        '{}'::bytea
    FROM old_table o;
    RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION fn_sync_message_body_purge_queue_truncate()
RETURNS TRIGGER AS $$
BEGIN
    INSERT INTO tx_outbox_for_kafka(domain_uid, part_key, kafka_key, kafka_value)
    VALUES (
        'sync.q',
        'pq',
        convert_to(
            json_build_object(
                'type', 'pq',
                'owner', '',
                'uid', '',
                'id', -1,
                'valueClass', '',
                'operation', 'TRUNCATE'
            )::text, 'UTF-8'
        ),
        convert_to(
            json_build_object(
                'operation', 'TRUNCATE',
                'table', 't_message_body_purge_queue'
            )::text, 'UTF-8'
        )
    );
    RETURN NULL;
END;
$$ LANGUAGE plpgsql;

-- t_message_body_purge_queue
CREATE TRIGGER trg_sync_message_body_purge_queue_insert
AFTER INSERT ON t_message_body_purge_queue
REFERENCING NEW TABLE AS new_table
FOR EACH STATEMENT EXECUTE FUNCTION fn_sync_message_body_purge_queue_insert();

CREATE TRIGGER trg_sync_message_body_purge_queue_update
AFTER UPDATE ON t_message_body_purge_queue
REFERENCING NEW TABLE AS new_table
FOR EACH STATEMENT EXECUTE FUNCTION fn_sync_message_body_purge_queue_update();

CREATE TRIGGER trg_sync_message_body_purge_queue_delete
AFTER DELETE ON t_message_body_purge_queue
REFERENCING OLD TABLE AS old_table
FOR EACH STATEMENT EXECUTE FUNCTION fn_sync_message_body_purge_queue_delete();

CREATE TRIGGER trg_sync_message_body_purge_queue_truncate
AFTER TRUNCATE ON t_message_body_purge_queue
FOR EACH STATEMENT EXECUTE FUNCTION fn_sync_message_body_purge_queue_truncate();


CREATE OR REPLACE FUNCTION fn_enable_message_body_purge_queue_sync_triggers()
RETURNS void AS $$
BEGIN
    ALTER TABLE t_message_body_purge_queue ENABLE TRIGGER trg_sync_message_body_purge_queue_insert;
    ALTER TABLE t_message_body_purge_queue ENABLE TRIGGER trg_sync_message_body_purge_queue_update;
    ALTER TABLE t_message_body_purge_queue ENABLE TRIGGER trg_sync_message_body_purge_queue_delete;
    ALTER TABLE t_message_body_purge_queue ENABLE TRIGGER trg_sync_message_body_purge_queue_truncate;
    RAISE NOTICE 'Queue synchronization triggers have been enabled';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION fn_disable_message_body_purge_queue_sync_triggers()
RETURNS void AS $$
BEGIN
    ALTER TABLE t_message_body_purge_queue DISABLE TRIGGER trg_sync_message_body_purge_queue_insert;
    ALTER TABLE t_message_body_purge_queue DISABLE TRIGGER trg_sync_message_body_purge_queue_update;
    ALTER TABLE t_message_body_purge_queue DISABLE TRIGGER trg_sync_message_body_purge_queue_delete;
    ALTER TABLE t_message_body_purge_queue DISABLE TRIGGER trg_sync_message_body_purge_queue_truncate;
    RAISE NOTICE 'Queue synchronization triggers have been disabled';
END;
$$ LANGUAGE plpgsql;

-- Enabled by server startup, if /etc/bm/kafka.properties is set
--SELECT fn_disable_message_body_purge_queue_sync_triggers();
--SELECT fn_enable_message_body_purge_queue_sync_triggers();
