/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.service.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.bluemind.backend.mail.api.IMailFinder;
import net.bluemind.backend.mail.api.MailFinderQuery;
import net.bluemind.backend.mail.api.MessageSearchResult;
import net.bluemind.backend.mail.api.SearchResult;
import net.bluemind.backend.mail.replica.indexing.IMailIndexService;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.container.service.internal.RBACManager;
import net.bluemind.directory.api.IDirectory;
import net.bluemind.domain.api.Domain;
import net.bluemind.index.MailIndexActivator;
import net.bluemind.role.api.BasicRoles;

public class MailFinderService implements IMailFinder {

	private ItemValue<Domain> domain;
	private IDirectory dirApi;
	private RBACManager rbac;

	public MailFinderService(ItemValue<Domain> domain, IDirectory dirApi, RBACManager rbacManager) {
		this.domain = domain;
		this.dirApi = dirApi;
		this.rbac = rbacManager;
	}

	@Override
	public SearchResult search(MailFinderQuery query) {
		rbac.forDomain(domain.uid).check(BasicRoles.ROLE_SYSTEM_MANAGER);
		IMailIndexService indexService = MailIndexActivator.getService();
		SearchResult resultsForAllDomains = indexService.search(domain, query);

		Set<String> ownersForDomain = new HashSet<>(dirApi.changeset(0L).created);
		List<MessageSearchResult> toRemoveForDomain = resultsForAllDomains.results.stream()
				.filter(tr -> ownersForDomain.contains(tr.owner)).toList();
		resultsForAllDomains.results = toRemoveForDomain;
		return resultsForAllDomains;
	}

}
