/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2017
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.service.internal;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class MAPIKeywordsHelper {

	public static final String KEYWORD_FLAG_PREFIX = "$MAPI$";

	public static String toImapFlag(String kw) {
		StringBuilder sb = new StringBuilder();
		sb.append(KEYWORD_FLAG_PREFIX);
		String toEncode = kw.substring(6);
		sb.append(Base64.getEncoder().encodeToString(toEncode.getBytes(StandardCharsets.UTF_8)));
		return sb.toString();
	}

	public static String fromImapFlag(String mapi) {
		if (isFlagKeyword(mapi)) {
			String b64 = mapi.substring(6);
			StringBuilder sb = new StringBuilder();
			sb.append(KEYWORD_FLAG_PREFIX);
			sb.append(new String(Base64.getDecoder().decode(b64), StandardCharsets.UTF_8));
			return sb.toString();
		} else {
			return null;
		}
	}

	public static boolean isFlagKeyword(String mapi) {
		return mapi.startsWith(KEYWORD_FLAG_PREFIX);
	}

}
