package net.bluemind.backend.mail.replica.service.deferredaction;

import java.util.Date;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.deferredaction.api.DeferredAction;
import net.bluemind.deferredaction.registry.DeferredActionExecution;
import net.bluemind.mailbox.api.Mailbox;

public class ScheduleMailDeferredAction extends DeferredAction {

	public static String ACTION_ID = "SEND_SCHEDULED_MAIL";
	public String mailboxUid;
	
	public static String reference(ItemValue<Mailbox> mailbox) {
		return mailbox.uid+"#"+ACTION_ID;
	}
	
	public ScheduleMailDeferredAction(DeferredAction deferredAction) {
		actionId = deferredAction.actionId;
		reference = deferredAction.reference;
		configuration = deferredAction.configuration;
		executionDate = deferredAction.executionDate;
		mailboxUid = getMailboxUid(deferredAction.reference);

	}
	public static String getMailboxUid(String reference) {
		return reference.substring(0, reference.indexOf('#'));
	}

	public static Date getExecutionDate(Long timestamp) {
		return new Date(timestamp + DeferredActionExecution.PERIOD);
	}

}
