package net.bluemind.backend.mail.replica.service.internal.hooks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.backend.mail.partfile.DocumentDbPartFileStore;
import net.bluemind.backend.mail.partfile.IPartFileStore;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.sessions.ISessionDeletionListener;

public class CleanTemporaryParts implements ISessionDeletionListener {

	private static final Logger logger = LoggerFactory.getLogger(CleanTemporaryParts.class);
	private IPartFileStore partFileStore;

	public CleanTemporaryParts() {
		partFileStore = DocumentDbPartFileStore.get();
	}

	@Override
	public void deleted(String identity, String sid, SecurityContext securityContext) {
		partFileStore.deleteAll(sid);
	}
}
