package net.bluemind.backend.mail.replica.service;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Suppliers;

import net.bluemind.backend.mail.api.IMailboxFoldersByContainer;
import net.bluemind.backend.mail.replica.api.IMailReplicaUids;
import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.core.auditlogs.ContainerElement.ContainerElementBuilder;
import net.bluemind.core.auditlogs.ILogMapperProvider;
import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.service.internal.ItemValueAuditLogService;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.directory.api.IDirectory;

public class DbMailboxRecordAuditLogService extends ItemValueAuditLogService<MailboxRecord> {
	private static final Logger logger = LoggerFactory.getLogger(DbMailboxRecordAuditLogService.class);

	private final Supplier<String> folderNameSupplier;

	public DbMailboxRecordAuditLogService(BmContext ctx, BaseContainerDescriptor cont,
			ILogMapperProvider<MailboxRecord> mapper) {
		super(ctx, cont, mapper);
		folderNameSupplier = Suppliers.memoizeWithExpiration(this::getFullFolderName, 1, TimeUnit.MINUTES);

	}

	@Override
	protected ContainerElementBuilder createContainerElement() {
		ContainerElementBuilder builder = super.createContainerElement();
		builder.name(folderNameSupplier.get());
		return builder;

	}

	private String getFullFolderName() {
		try {
			IDirectory dirService = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM)
					.instance(IDirectory.class, domainUid);
			DirEntry dirEntry = dirService.findByEntryUid(container.owner);
			String subTree = IMailReplicaUids.subtreeUid(domainUid, dirEntry);
			IMailboxFoldersByContainer mailboxFolderService = ServerSideServiceProvider
					.getProvider(SecurityContext.SYSTEM).instance(IMailboxFoldersByContainer.class, subTree);
			return mailboxFolderService.getFullName(IMailReplicaUids.uniqueId(container.uid));
		} catch (Exception e) {
			logger.error("Cannot find fullname for '{}', use '{}' instead ", container.uid, container.name);
			return container.name;
		}

	}

}
