package net.bluemind.backend.mail.replica.service;

import net.bluemind.backend.cyrus.partitions.CyrusPartition;
import net.bluemind.backend.mail.replica.api.IDbMessageBodies;
import net.bluemind.backend.mail.replica.api.INotIndexedBodies;
import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.backend.mail.replica.indexing.IMailIndexService;
import net.bluemind.backend.mail.replica.indexing.NoopMailIndexService;
import net.bluemind.backend.mail.replica.indexing.RecordIndexActivator;
import net.bluemind.backend.mail.replica.service.internal.DbMailboxRecordsAuditLogMapper;
import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.ContainerUid;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.repository.IContainerRouteStore;
import net.bluemind.core.container.service.internal.ItemValueAuditLogService;
import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.provider.RepositoryProvider;

public class RecordServiceProvider {
	private static final IMailIndexService NOOP = new NoopMailIndexService();

	public static IRecordServiceProvider get(String name) {
		if (name.equals("Drafts") || name.equals("Outbox")) {
			return new NoIndexServiceProvider();
		} else {
			return new DefaultServiceProvider();
		}
	}

	static class DefaultServiceProvider implements IRecordServiceProvider {

		@Override
		public IDbMessageBodies getBodiesService(BmContext context, String partition) {
			return context.provider().instance(IDbMessageBodies.class, partition);
		}

		@Override
		public IMailIndexService getMailIndexService() {
			return RecordIndexActivator.getIndexer().orElse(NOOP);
		}

		@Override
		public ItemValueAuditLogService<MailboxRecord> getAuditlogService(BmContext context,
				BaseContainerDescriptor descriptor) {
			IContainerRouteStore router = RepositoryProvider.instance(IContainerRouteStore.class, context);
			DataLocation loc = router.routeOf(ContainerUid.of(descriptor.uid));
			String partition = CyrusPartition.forServerAndDomain(loc.serverUid(), descriptor.domainUid).name;
			DbMailboxRecordsAuditLogMapper mapper = new DbMailboxRecordsAuditLogMapper(descriptor,
					getBodiesService(context, partition));
			return new DbMailboxRecordAuditLogService(context, descriptor, mapper);
		}

	}

	static class NoIndexServiceProvider implements IRecordServiceProvider {

		@Override
		public IDbMessageBodies getBodiesService(BmContext context, String partition) {
			return context.provider().instance(INotIndexedBodies.class, partition);
		}

		@Override
		public IMailIndexService getMailIndexService() {
			return NOOP;
		}

		@Override
		public ItemValueAuditLogService<MailboxRecord> getAuditlogService(BmContext cotext,
				BaseContainerDescriptor descriptor) {
			return null;
		}

	}
}
