/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.service.internal;

import net.bluemind.backend.mail.replica.api.MailboxReplicaRootDescriptor.Namespace;
import net.bluemind.backend.mail.replica.api.SubtreeLocation;
import net.bluemind.core.rest.BmContext;

public class Location {

	private Location() {
	}

	public static String imapPath(SubtreeLocation loc, BmContext context) {
		Namespace ns = loc.namespace();
		if (ns == Namespace.users) {

			if (!context.getSecurityContext().fromGlobalVirt()
					&& !loc.subtreeContainer.contains("!user." + context.getSecurityContext().getSubject())) {
				String root = loc.contName.substring(6);
				if (loc.boxName.equals("INBOX")) {
					return "Autres utilisateurs/" + root;
				}
				return "Autres utilisateurs/" + root + "/" + loc.boxName;
			}
			return loc.boxName;
		} else {
			return "Dossiers partagés/" + loc.boxName;
		}
	}
}
