/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2017
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.service.internal;

import java.util.function.Supplier;

import net.bluemind.backend.mail.parsing.BodyStreamProcessor.MessageBodyData;
import net.bluemind.backend.mail.replica.api.IMessageBodyTierChange;
import net.bluemind.backend.mail.replica.api.INotIndexedBodies;
import net.bluemind.backend.mail.replica.service.sds.MessageBodyObjectStore;
import net.bluemind.backend.mail.repository.IMessageBodyStore;

public class DbMessageBodiesNoIndexService extends DbMessageBodiesService implements INotIndexedBodies {

	public DbMessageBodiesNoIndexService(IMessageBodyStore bodyStore, Supplier<MessageBodyObjectStore> bodyObjectStore,
			Supplier<IMessageBodyTierChange> bodyTierChangeService) {
		super(bodyStore, bodyObjectStore, bodyTierChangeService);
	}

	@Override
	public int updateAndIndex(MessageBodyData bodyData) {
		int affectedRows = update(bodyData.body);
		return affectedRows;
	}

}
