/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.persistence.factories;

import javax.sql.DataSource;

import net.bluemind.backend.mail.replica.persistence.MailboxRecordStore;
import net.bluemind.backend.mail.repository.IMailboxRecordStore;
import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.persistence.DataSourceRouter;
import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.provider.IBiContainerBoundFactory;

public class MailboxRecordStoreFactory implements IBiContainerBoundFactory<IMailboxRecordStore> {

	@Override
	public Class<IMailboxRecordStore> factoryClass() {
		return IMailboxRecordStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public IMailboxRecordStore instance(BmContext context, Container first, Container second) throws ServerFault {
		DataSource ds = DataSourceRouter.get(context, first.uid);
		return new MailboxRecordStore(ds, first, second);
	}

}
